<?php
/**
 * Admin form editor template
 *
 * @package SPAI_Contact_Form
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Initialize variables
$form_id = isset($_GET['form_id']) ? intval($_GET['form_id']) : null;
$form = null;
$form_name = '';
$form_fields = array();
$form_settings = array();

if ($form_id) {
    $db_handler = new SPAI_DB_Handler();
    $form = $db_handler->get_form($form_id);
    
    if ($form) {
        $form_name = $form->form_name;
        $form_fields = json_decode($form->form_fields, true) ?: array();
        $form_settings = json_decode($form->form_settings, true) ?: array();
    }
}

// Default form fields if new form
if (empty($form_fields)) {
    $form_fields = array(
        array(
            'id' => 'field_first_name',
            'type' => 'text',
            'label' => 'First Name',
            'name' => 'first_name',
            'required' => true,
            'placeholder' => 'Enter your first name'
        ),
        array(
            'id' => 'field_last_name',
            'type' => 'text',
            'label' => 'Last Name',
            'name' => 'last_name',
            'required' => true,
            'placeholder' => 'Enter your last name'
        ),
        array(
            'id' => 'field_email',
            'type' => 'email',
            'label' => 'Email',
            'name' => 'email',
            'required' => true,
            'placeholder' => 'your@email.com'
        ),
        array(
            'id' => 'field_phone',
            'type' => 'phone',
            'label' => 'Phone',
            'name' => 'phone',
            'required' => true,
            'placeholder' => '+1234567890'
        )
    );
}
?>

<div class="wrap spai-admin-wrapper">
    <div class="spai-admin-header">
        <h1><?php echo $form_id ? __('Edit Form', 'spai-contact-form') : __('Add New Form', 'spai-contact-form'); ?></h1>
    </div>
    
    <div class="spai-admin-content">
        <div class="spai-tabs">
            <button class="spai-tab active" data-tab="form-settings">
                <?php _e('Form Settings', 'spai-contact-form'); ?>
            </button>
            <button class="spai-tab" data-tab="form-fields">
                <?php _e('Form Fields', 'spai-contact-form'); ?>
            </button>
            <button class="spai-tab" data-tab="email-confirmation">
                <?php _e('Email Confirmation', 'spai-contact-form'); ?>
            </button>
            <?php if (class_exists('SynLawn_MyEmma_API')): ?>
            <button class="spai-tab" data-tab="newsletter">
                <?php _e('MyEmma', 'spai-contact-form'); ?>
            </button>
            <?php endif; ?>
            <button class="spai-tab" data-tab="field-mapping">
                <?php _e('Field Mapping', 'spai-contact-form'); ?>
            </button>
            <button class="spai-tab" data-tab="import-monday">
                <?php _e('Import', 'spai-contact-form'); ?>
            </button>
        </div>
        
        <!-- Form Settings Tab -->
        <div id="form-settings" class="spai-tab-content active">
            <table class="form-table">
                <tr>
                    <th scope="row">
                        <label for="form_name"><?php _e('Form Name', 'spai-contact-form'); ?></label>
                    </th>
                    <td>
                        <input type="text" id="form_name" name="form_name" 
                               value="<?php echo esc_attr($form_name); ?>" 
                               class="regular-text" required>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="submit_text"><?php _e('Submit Button Text', 'spai-contact-form'); ?></label>
                    </th>
                    <td>
                        <input type="text" id="submit_text" name="submit_text" 
                               value="<?php echo esc_attr($form_settings['submit_text'] ?? 'Submit'); ?>" 
                               class="regular-text">
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="redirect_url"><?php _e('Redirect URL (optional)', 'spai-contact-form'); ?></label>
                    </th>
                    <td>
                        <input type="url" id="redirect_url" name="redirect_url" 
                               value="<?php echo esc_attr($form_settings['redirect_url'] ?? ''); ?>" 
                               class="regular-text">
                        <p class="description">
                            <?php _e('Redirect to this URL after successful submission', 'spai-contact-form'); ?>
                        </p>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <?php _e('Security', 'spai-contact-form'); ?>
                    </th>
                    <td>
                        <label>
                            <input type="checkbox" name="enable_honeypot" value="1" 
                                   <?php checked(!empty($form_settings['enable_honeypot'])); ?>>
                            <?php _e('Enable honeypot spam protection', 'spai-contact-form'); ?>
                        </label>
                    </td>
                </tr>
                
                <!-- Google Analytics & Ads Tracking -->
                <tr>
                    <th scope="row" colspan="2">
                        <h3><?php _e('Analytics & Conversion Tracking', 'spai-contact-form'); ?></h3>
                        <p class="description"><?php _e('Configure Google Analytics and Google Ads conversion tracking for this form.', 'spai-contact-form'); ?></p>
                        <div style="background: #f0f4f7; padding: 15px; margin: 10px 0; border-left: 4px solid #2271b1; font-size: 13px;">
                            <strong><?php _e('How to use:', 'spai-contact-form'); ?></strong>
                            <ol style="margin: 10px 0 0 20px;">
                                <li><?php _e('Get your Google Ads Conversion ID and Label from your Google Ads account', 'spai-contact-form'); ?></li>
                                <li><?php _e('Enter them in the fields below (both are required for Google Ads tracking)', 'spai-contact-form'); ?></li>
                                <li><?php _e('Optionally customize the GA4 event name (default: form_submission)', 'spai-contact-form'); ?></li>
                                <li><?php _e('Make sure Google Tag (gtag.js) is installed on your website', 'spai-contact-form'); ?></li>
                                <li><?php _e('Submit a test form and check browser console for tracking confirmation', 'spai-contact-form'); ?></li>
                            </ol>
                            <em><?php _e('Note: Leave fields empty to disable tracking for this form.', 'spai-contact-form'); ?></em>
                        </div>
                    </th>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="google_ads_conversion_id"><?php _e('Google Ads Conversion ID', 'spai-contact-form'); ?></label>
                    </th>
                    <td>
                        <input type="text" id="google_ads_conversion_id" name="google_ads_conversion_id" 
                               value="<?php echo esc_attr($form_settings['google_ads_conversion_id'] ?? ''); ?>" 
                               class="regular-text">
                        <p class="description">
                            <?php _e('Your Google Ads Conversion ID (e.g., AW-123456789)', 'spai-contact-form'); ?>
                        </p>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="google_ads_conversion_label"><?php _e('Google Ads Conversion Label', 'spai-contact-form'); ?></label>
                    </th>
                    <td>
                        <input type="text" id="google_ads_conversion_label" name="google_ads_conversion_label" 
                               value="<?php echo esc_attr($form_settings['google_ads_conversion_label'] ?? ''); ?>" 
                               class="regular-text">
                        <p class="description">
                            <?php _e('Your Google Ads Conversion Label (e.g., abcDefGHI-jkLMnopQr)', 'spai-contact-form'); ?>
                        </p>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="ga4_event_name"><?php _e('Google Analytics 4 Event Name', 'spai-contact-form'); ?></label>
                    </th>
                    <td>
                        <input type="text" id="ga4_event_name" name="ga4_event_name" 
                               value="<?php echo esc_attr($form_settings['ga4_event_name'] ?? 'form_submission'); ?>" 
                               class="regular-text">
                        <p class="description">
                            <?php _e('Custom event name for GA4 tracking (default: form_submission)', 'spai-contact-form'); ?>
                        </p>
                    </td>
                </tr>
            </table>
        </div>
        
        <!-- Form Fields Tab -->
        <div id="form-fields" class="spai-tab-content">
            <div id="form-builder-container">
                <div class="spai-form-builder-wrapper">
                    <div class="spai-form-builder-sidebar">
                        <h3><?php _e('Add Fields', 'spai-contact-form'); ?></h3>
                        
                        <div class="spai-field-buttons">
                            <button class="button spai-add-field" data-type="text">
                                <span class="dashicons dashicons-editor-textcolor"></span> Text Field
                            </button>
                            <button class="button spai-add-field" data-type="email">
                                <span class="dashicons dashicons-email"></span> Email
                            </button>
                            <button class="button spai-add-field" data-type="phone">
                                <span class="dashicons dashicons-phone"></span> Phone
                            </button>
                            <button class="button spai-add-field" data-type="textarea">
                                <span class="dashicons dashicons-text"></span> Textarea
                            </button>
                            <button class="button spai-add-field" data-type="select">
                                <span class="dashicons dashicons-arrow-down"></span> Dropdown
                            </button>
                            <button class="button spai-add-field" data-type="radio">
                                <span class="dashicons dashicons-marker"></span> Radio Buttons
                            </button>
                            <button class="button spai-add-field" data-type="checkbox">
                                <span class="dashicons dashicons-yes"></span> Checkbox
                            </button>
                            <button class="button spai-add-field" data-type="multichoice">
                                <span class="dashicons dashicons-tag"></span> Multi Choice
                            </button>
                            <button class="button spai-add-field" data-type="consent_checkbox">
                                <span class="dashicons dashicons-yes-alt"></span> Consent Checkbox
                            </button>
                            <button class="button spai-add-field" data-type="date">
                                <span class="dashicons dashicons-calendar"></span> Date
                            </button>
                            <button class="button spai-add-field" data-type="file">
                                <span class="dashicons dashicons-upload"></span> File Upload
                            </button>
                            <button class="button spai-add-field" data-type="hidden">
                                <span class="dashicons dashicons-hidden"></span> Hidden Field
                            </button>
                            <button class="button spai-add-field" data-type="section">
                                <span class="dashicons dashicons-editor-insertmore"></span> Section Header
                            </button>
                        </div>
                    </div>
                    
                    <div class="spai-form-builder-main">
                        <h3><?php _e('Form Fields', 'spai-contact-form'); ?></h3>
                        
                        <!-- UTM Marketing Data Instructions -->
                        <div style="background: #e7f3ff; border: 1px solid #b3d9ff; border-radius: 4px; padding: 15px; margin-bottom: 20px;">
                            <h4 style="margin-top: 0; color: #0073aa;">
                                <span class="dashicons dashicons-chart-line" style="vertical-align: middle; margin-right: 5px;"></span>
                                <?php _e('UTM Marketing Data Tracking', 'spai-contact-form'); ?>
                            </h4>
                            <p><?php _e('Track campaign attribution by capturing UTM parameters from your ads and marketing campaigns.', 'spai-contact-form'); ?></p>
                            
                            <div style="background: white; padding: 12px; border-radius: 3px; margin: 10px 0;">
                                <strong><?php _e('How to enable UTM tracking:', 'spai-contact-form'); ?></strong>
                                <ol style="margin: 8px 0 0 20px; font-size: 13px;">
                                    <li><?php _e('Add a <strong>Hidden Field</strong> to your form', 'spai-contact-form'); ?></li>
                                    <li><?php _e('Set the field name to: <code>marketing_data</code>', 'spai-contact-form'); ?></li>
                                    <li><?php _e('Save your form', 'spai-contact-form'); ?></li>
                                    <li><?php _e('Map the field to Monday.com in the Field Mapping tab', 'spai-contact-form'); ?></li>
                                </ol>
                            </div>
                            
                            <div style="font-size: 12px; color: #666;">
                                <strong><?php _e('What gets captured:', 'spai-contact-form'); ?></strong> 
                                <?php _e('UTM source, campaign, medium, referrer, and landing page in format: "Source: facebook, Campaign: summer_2024, Medium: cpc, Referrer: facebook.com, Landing: /page"', 'spai-contact-form'); ?>
                            </div>
                        </div>
                        
                        <div id="form-fields-list" class="spai-form-fields-list">
                            <!-- Fields will be rendered here -->
                        </div>
                        <?php if (empty($form_fields)): ?>
                            <p class="description"><?php _e('Click on field types to add them to your form.', 'spai-contact-form'); ?></p>
                        <?php endif; ?>
                    </div>
                    
                    <div class="spai-form-builder-properties">
                        <h3><?php _e('Field Properties', 'spai-contact-form'); ?></h3>
                        <div id="field-properties">
                            <p class="description"><?php _e('Select a field to edit its properties', 'spai-contact-form'); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Email Confirmation Tab -->
        <div id="email-confirmation" class="spai-tab-content">
            <?php
            // Get email confirmation settings from form_settings
            $email_settings = isset($form_settings['email_confirmation']) ? $form_settings['email_confirmation'] : array();
            $email_enabled = !empty($email_settings['enabled']);
            $email_subject = isset($email_settings['subject']) ? $email_settings['subject'] : 'Thank you for contacting us!';
            $email_from_name = isset($email_settings['from_name']) ? $email_settings['from_name'] : get_bloginfo('name');
            $email_from_email = isset($email_settings['from_email']) ? $email_settings['from_email'] : get_option('admin_email');
            $email_reply_to = isset($email_settings['reply_to']) ? $email_settings['reply_to'] : '';
            $email_logo_url = isset($email_settings['logo_url']) ? $email_settings['logo_url'] : '';
            $email_phone_number = isset($email_settings['phone_number']) ? $email_settings['phone_number'] : '';
            $email_body_text = isset($email_settings['body_text']) ? $email_settings['body_text'] : "Hi {first_name},\n\nThank you for your interest in SYNLawn Chicago!\n\nOne of our specialists will be in touch with you shortly to discuss your project.\n\nIn the meantime, we've attached our Buyer's Guide to help you learn more about our products.";
            $email_footer_text = isset($email_settings['footer_text']) ? $email_settings['footer_text'] : '';
            $attachment_field = isset($email_settings['attachment_field']) ? $email_settings['attachment_field'] : '';
            $attachment_mapping = isset($email_settings['attachment_mapping']) ? $email_settings['attachment_mapping'] : array();
            ?>

            <div style="max-width: 800px;">
                <h2><?php _e('Email Confirmation Settings', 'spai-contact-form'); ?></h2>
                <p class="description"><?php _e('Send an automatic confirmation email to users after form submission.', 'spai-contact-form'); ?></p>

                <table class="form-table">
                    <tr>
                        <th scope="row"><?php _e('Enable', 'spai-contact-form'); ?></th>
                        <td>
                            <label>
                                <input type="checkbox" id="email_enabled" name="email_enabled" value="1" <?php checked($email_enabled); ?>>
                                <?php _e('Send confirmation email to submitter', 'spai-contact-form'); ?>
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="email_subject"><?php _e('Email Subject', 'spai-contact-form'); ?></label>
                        </th>
                        <td>
                            <input type="text" id="email_subject" name="email_subject"
                                   value="<?php echo esc_attr($email_subject); ?>"
                                   class="large-text">
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="email_from_name"><?php _e('From Name', 'spai-contact-form'); ?></label>
                        </th>
                        <td>
                            <input type="text" id="email_from_name" name="email_from_name"
                                   value="<?php echo esc_attr($email_from_name); ?>"
                                   class="regular-text">
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="email_from_email"><?php _e('From Email', 'spai-contact-form'); ?></label>
                        </th>
                        <td>
                            <input type="email" id="email_from_email" name="email_from_email"
                                   value="<?php echo esc_attr($email_from_email); ?>"
                                   class="regular-text">
                            <p class="description"><?php _e('Use an email address from your domain to avoid spam filters.', 'spai-contact-form'); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="email_reply_to"><?php _e('Reply-To Email', 'spai-contact-form'); ?></label>
                        </th>
                        <td>
                            <input type="email" id="email_reply_to" name="email_reply_to"
                                   value="<?php echo esc_attr($email_reply_to); ?>"
                                   class="regular-text" placeholder="sales@example.com">
                            <p class="description"><?php _e('When recipient clicks Reply, email goes here (e.g., sales person).', 'spai-contact-form'); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="email_logo_url"><?php _e('Logo URL (optional)', 'spai-contact-form'); ?></label>
                        </th>
                        <td>
                            <input type="url" id="email_logo_url" name="email_logo_url"
                                   value="<?php echo esc_attr($email_logo_url); ?>"
                                   class="large-text" placeholder="https://example.com/logo.png">
                            <p class="description"><?php _e('Full URL to your logo image for the email header.', 'spai-contact-form'); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="email_phone_number"><?php _e('Phone Number (optional)', 'spai-contact-form'); ?></label>
                        </th>
                        <td>
                            <input type="text" id="email_phone_number" name="email_phone_number"
                                   value="<?php echo esc_attr($email_phone_number); ?>"
                                   class="regular-text" placeholder="(312) 555-1234">
                            <p class="description"><?php _e('Adds "Questions? Call us at..." to the email.', 'spai-contact-form'); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="email_body_text"><?php _e('Email Body', 'spai-contact-form'); ?></label>
                        </th>
                        <td>
                            <textarea id="email_body_text" name="email_body_text" rows="6" class="large-text"><?php echo esc_textarea($email_body_text); ?></textarea>
                            <p class="description"><?php _e('Use {first_name} to include the submitter\'s name. Line breaks will be preserved.', 'spai-contact-form'); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="email_footer_text"><?php _e('Footer Text (optional)', 'spai-contact-form'); ?></label>
                        </th>
                        <td>
                            <textarea id="email_footer_text" name="email_footer_text" rows="3" class="large-text" placeholder="Company Name&#10;123 Main St, City, State&#10;www.example.com"><?php echo esc_textarea($email_footer_text); ?></textarea>
                        </td>
                    </tr>
                </table>

                <!-- PDF Attachment Section -->
                <h3 style="margin-top: 30px; padding-top: 20px; border-top: 1px solid #ccc;">
                    <?php _e('PDF Attachment (Optional)', 'spai-contact-form'); ?>
                </h3>
                <p class="description"><?php _e('Automatically attach a PDF based on a field selection. Great for sending different buyer guides based on project type.', 'spai-contact-form'); ?></p>

                <table class="form-table">
                    <tr>
                        <th scope="row">
                            <label for="attachment_field"><?php _e('Attach PDF Based On', 'spai-contact-form'); ?></label>
                        </th>
                        <td>
                            <select id="attachment_field" name="attachment_field" class="regular-text">
                                <option value=""><?php _e('-- No attachment --', 'spai-contact-form'); ?></option>
                                <!-- Options populated by JavaScript from form fields -->
                            </select>
                            <p class="description"><?php _e('Select a dropdown/radio field. The PDF attachment will be determined by the user\'s selection.', 'spai-contact-form'); ?></p>
                        </td>
                    </tr>
                </table>

                <div id="attachment-mapping-container" style="display: none; margin-top: 20px; padding: 20px; background: #f9f9f9; border: 1px solid #ddd; border-radius: 4px;">
                    <h4 style="margin-top: 0;"><?php _e('Map Field Values to PDF URLs', 'spai-contact-form'); ?></h4>
                    <p class="description"><?php _e('Enter the full URL to the PDF file for each option value.', 'spai-contact-form'); ?></p>
                    <table id="attachment-mapping-table" class="widefat" style="margin-top: 15px;">
                        <thead>
                            <tr>
                                <th style="width: 200px;"><?php _e('When value is...', 'spai-contact-form'); ?></th>
                                <th><?php _e('Attach this PDF URL', 'spai-contact-form'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Rows populated by JavaScript -->
                        </tbody>
                    </table>
                </div>

                <!-- Test Email Button -->
                <div style="margin-top: 30px; padding-top: 20px; border-top: 1px solid #ccc;">
                    <h3 style="margin-top: 0;"><?php _e('Test Email Delivery', 'spai-contact-form'); ?></h3>
                    <p class="description"><?php _e('Send a real test email using your configured settings above.', 'spai-contact-form'); ?></p>
                    <table class="form-table">
                        <tr>
                            <th scope="row">
                                <label for="test_email_address"><?php _e('Send Test To', 'spai-contact-form'); ?></label>
                            </th>
                            <td>
                                <input type="email" id="test_email_address" name="test_email_address"
                                       value=""
                                       class="regular-text" placeholder="your-email@example.com">
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="test_first_name"><?php _e('Test First Name', 'spai-contact-form'); ?></label>
                            </th>
                            <td>
                                <input type="text" id="test_first_name" name="test_first_name"
                                       value="John"
                                       class="regular-text">
                                <p class="description"><?php _e('Used for {first_name} placeholder', 'spai-contact-form'); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">
                                <label for="test_attachment_option"><?php _e('Test With Attachment', 'spai-contact-form'); ?></label>
                            </th>
                            <td>
                                <select id="test_attachment_option" name="test_attachment_option" class="regular-text">
                                    <option value=""><?php _e('-- No attachment --', 'spai-contact-form'); ?></option>
                                    <!-- Options populated by JavaScript from attachment mapping -->
                                </select>
                                <p class="description"><?php _e('Select which PDF to attach for this test', 'spai-contact-form'); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row"></th>
                            <td>
                                <button type="button" id="test-email-btn" class="button button-primary">
                                    <span class="dashicons dashicons-email" style="vertical-align: middle;"></span>
                                    <?php _e('Send Test Email Now', 'spai-contact-form'); ?>
                                </button>
                                <span id="test-email-result" style="margin-left: 15px;"></span>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>

        <!-- Newsletter Tab (only if MyEmma plugin active) -->
        <?php if (class_exists('SynLawn_MyEmma_API')): ?>
        <div id="newsletter" class="spai-tab-content">
            <?php
            // Get newsletter settings from form_settings
            $newsletter_settings = isset($form_settings['newsletter']) ? $form_settings['newsletter'] : array();
            $newsletter_enabled = !empty($newsletter_settings['enabled']);
            $newsletter_field = isset($newsletter_settings['field']) ? $newsletter_settings['field'] : '';
            $newsletter_mapping = isset($newsletter_settings['mapping']) ? $newsletter_settings['mapping'] : array();

            // Get MyEmma group IDs from plugin settings
            $myemma_settings = get_option('synlawn_myemma_settings', array());
            $residential_group_id = isset($myemma_settings['residential_group_id']) ? $myemma_settings['residential_group_id'] : '';
            $commercial_group_id = isset($myemma_settings['commercial_group_id']) ? $myemma_settings['commercial_group_id'] : '';
            ?>

            <div style="max-width: 800px;">
                <h2><?php _e('MyEmma Integration', 'spai-contact-form'); ?></h2>
                <p class="description"><?php _e('Automatically add form submitters to MyEmma groups based on their selection.', 'spai-contact-form'); ?></p>

                <table class="form-table">
                    <tr>
                        <th scope="row"><?php _e('Enable', 'spai-contact-form'); ?></th>
                        <td>
                            <label>
                                <input type="checkbox" id="newsletter_enabled" name="newsletter_enabled" value="1" <?php checked($newsletter_enabled); ?>>
                                <?php _e('Add submitters to MyEmma', 'spai-contact-form'); ?>
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">
                            <label for="newsletter_field"><?php _e('Group Based On Field', 'spai-contact-form'); ?></label>
                        </th>
                        <td>
                            <select id="newsletter_field" name="newsletter_field" class="regular-text" data-saved-value="<?php echo esc_attr($newsletter_field); ?>">
                                <option value=""><?php _e('-- Select field --', 'spai-contact-form'); ?></option>
                                <!-- Options populated by JavaScript from form fields -->
                            </select>
                            <p class="description"><?php _e('Select which field determines the newsletter group (e.g., Project Type).', 'spai-contact-form'); ?></p>
                        </td>
                    </tr>
                </table>

                <div id="newsletter-mapping-container" style="display: none; margin-top: 20px; padding: 20px; background: #f9f9f9; border: 1px solid #ddd; border-radius: 4px;">
                    <h4 style="margin-top: 0;"><?php _e('Map Field Values to MyEmma Groups', 'spai-contact-form'); ?></h4>
                    <p class="description"><?php _e('Select which MyEmma group each field value should be added to.', 'spai-contact-form'); ?></p>
                    <table id="newsletter-mapping-table" class="widefat" style="margin-top: 15px;">
                        <thead>
                            <tr>
                                <th style="width: 200px;"><?php _e('When value is...', 'spai-contact-form'); ?></th>
                                <th><?php _e('Add to MyEmma group', 'spai-contact-form'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Rows populated by JavaScript -->
                        </tbody>
                    </table>
                </div>

                <!-- Hidden fields to store MyEmma group IDs for JavaScript -->
                <input type="hidden" id="myemma_residential_group" value="<?php echo esc_attr($residential_group_id); ?>">
                <input type="hidden" id="myemma_commercial_group" value="<?php echo esc_attr($commercial_group_id); ?>">
                <input type="hidden" id="newsletter_mapping_data" value="<?php echo esc_attr(json_encode($newsletter_mapping)); ?>">
            </div>
        </div>
        <?php endif; ?>

        <!-- Field Mapping Tab -->
        <div id="field-mapping" class="spai-tab-content">
            <?php include SPAI_CONTACT_FORM_PLUGIN_DIR . 'templates/admin/field-mapping.php'; ?>
        </div>
        
        <!-- Import Tab -->
        <div id="import-monday" class="spai-tab-content">
            <div style="max-width: 800px; margin: 20px 0;">
                <h2><?php _e('Import from Monday.com', 'spai-contact-form'); ?></h2>
                <p><?php _e('Import form fields directly from your Monday.com board. This will create form fields based on the columns in your selected board.', 'spai-contact-form'); ?></p>
                
                <div style="background: #f0f8ff; border: 1px solid #d0e4ff; border-radius: 4px; padding: 20px; margin: 20px 0;">
                    <h3 style="margin-top: 0;"><?php _e('How it works:', 'spai-contact-form'); ?></h3>
                    <ol>
                        <li><?php _e('Click the "Import Fields" button below', 'spai-contact-form'); ?></li>
                        <li><?php _e('Enter your Monday.com API key and Board ID', 'spai-contact-form'); ?></li>
                        <li><?php _e('The system will fetch your board columns and create matching form fields', 'spai-contact-form'); ?></li>
                        <li><?php _e('Only supported field types will be imported', 'spai-contact-form'); ?></li>
                    </ol>
                    
                    <p><strong><?php _e('Note:', 'spai-contact-form'); ?></strong> <?php _e('This will replace any existing fields in your form.', 'spai-contact-form'); ?></p>
                </div>
                
                <button class="button button-primary button-large" id="import-monday-fields">
                    <span class="dashicons dashicons-download" style="vertical-align: middle; margin-right: 5px;"></span>
                    <?php _e('Import Fields from Monday.com', 'spai-contact-form'); ?>
                </button>
                
                <div style="margin-top: 20px;">
                    <h4><?php _e('Where to find your Board ID:', 'spai-contact-form'); ?></h4>
                    <p><?php _e('1. Open your Monday.com board', 'spai-contact-form'); ?><br>
                    <?php _e('2. Look at the URL in your browser', 'spai-contact-form'); ?><br>
                    <?php _e('3. The board ID is the number in the URL', 'spai-contact-form'); ?><br>
                    <?php _e('Example: https://yourworkspace.monday.com/boards/1234567890 (Board ID: 1234567890)', 'spai-contact-form'); ?></p>
                </div>
            </div>
        </div>
        
        <p class="submit">
            <button type="button" id="save-form" class="button button-primary">
                <?php _e('Save Form', 'spai-contact-form'); ?>
            </button>
            <?php if ($form_id): ?>
                <span style="margin-left: 20px;">
                    <?php _e('Shortcode:', 'spai-contact-form'); ?> 
                    <code>[spai_form id="<?php echo $form_id; ?>"]</code>
                </span>
            <?php endif; ?>
        </p>
    </div>
</div>

<script>
// Pass form fields to JavaScript
var spaiFormFields = <?php echo json_encode($form_fields); ?>;
var spaiFormId = <?php echo $form_id ? $form_id : 'null'; ?>;
// Email confirmation settings
var spaiEmailSettings = {
    attachment_field: <?php echo json_encode($attachment_field); ?>,
    attachment_mapping: <?php echo json_encode($attachment_mapping); ?>
};
</script>
