<?php
/**
 * Plugin Name:       SPAI Contact Form
 * Plugin URI:        https://salespartnerai.com/
 * Description:       Unified contact form system with modular integrations for Monday.com, SalesPartnerAI, and future CRMs
 * Version:           1.0.0
 * Requires at least: 5.8
 * Requires PHP:      7.4
 * Author:            SalesPartnerAI
 * Author URI:        https://salespartnerai.com/
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       spai-contact-form
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

// Debug logging

/**
 * Plugin version
 */
define('SPAI_CONTACT_FORM_VERSION', '1.0.0.' . time());

/**
 * Plugin paths
 */
define('SPAI_CONTACT_FORM_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('SPAI_CONTACT_FORM_PLUGIN_URL', plugin_dir_url(__FILE__));
define('SPAI_CONTACT_FORM_PLUGIN_FILE', __FILE__);
define('SPAI_CONTACT_FORM_PLUGIN_BASENAME', plugin_basename(__FILE__));

/**
 * Upload paths
 */
define('SPAI_CONTACT_FORM_UPLOAD_DIR', 'spai-forms');


/**
 * The code that runs during plugin activation
 */
function spai_contact_form_activate() {
    require_once SPAI_CONTACT_FORM_PLUGIN_DIR . 'includes/core/class-spai-activator.php';
    SPAI_Activator::activate();
}

/**
 * The code that runs during plugin deactivation
 */
function spai_contact_form_deactivate() {
    require_once SPAI_CONTACT_FORM_PLUGIN_DIR . 'includes/core/class-spai-deactivator.php';
    SPAI_Deactivator::deactivate();
}

register_activation_hook(__FILE__, 'spai_contact_form_activate');
register_deactivation_hook(__FILE__, 'spai_contact_form_deactivate');

/**
 * The core plugin class
 */
require SPAI_CONTACT_FORM_PLUGIN_DIR . 'includes/core/class-spai-core.php';

/**
 * Convert PHP size notation to bytes (utility function)
 */
function spai_convert_to_bytes($value) {
    $value = trim($value);
    $last = strtolower($value[strlen($value)-1]);
    $value = (int)$value;
    switch($last) {
        case 'g': $value *= 1024;
        case 'm': $value *= 1024;
        case 'k': $value *= 1024;
    }
    return $value;
}

/**
 * Get PHP upload limits (utility function for use in templates)
 */
function spai_get_php_upload_limits() {
    // Get PHP configuration values
    $max_upload_size = ini_get('upload_max_filesize');
    $max_post_size = ini_get('post_max_size');
    $max_file_uploads = ini_get('max_file_uploads');
    
    // Convert to bytes for comparison
    $max_upload_bytes = spai_convert_to_bytes($max_upload_size);
    $max_post_bytes = spai_convert_to_bytes($max_post_size);
    
    // Effective maximum is the smaller of upload_max_filesize and post_max_size
    $effective_max_bytes = min($max_upload_bytes, $max_post_bytes);
    $effective_max_mb = floor($effective_max_bytes / (1024 * 1024));
    
    return array(
        'upload_max_filesize' => $max_upload_size,
        'post_max_size' => $max_post_size,
        'max_file_uploads' => (int) $max_file_uploads,
        'max_file_size_mb' => $effective_max_mb,
        'max_file_size_bytes' => $effective_max_bytes
    );
}

/**
 * Check if a field is required - handles both boolean and string values
 * Global utility function for use in templates and classes
 */
function spai_is_field_required($field) {
    if (!isset($field['required'])) {
        return false;
    }
    
    $required = $field['required'];
    
    // Handle string boolean values
    if (is_string($required)) {
        return $required === 'true' || $required === '1';
    }
    
    // Handle actual boolean values
    return (bool) $required;
}

/**
 * Begins execution of the plugin
 */
function spai_contact_form_run() {
    try {
        $plugin = new SPAI_Core();
        $plugin->run();
    } catch (Exception $e) {
    }
}

// Initialize the plugin
spai_contact_form_run();
