<?php
/**
 * Security utility
 *
 * @package SPAI_Contact_Form
 */

class SPAI_Security {
    
    /**
     * Generate form nonce
     */
    public static function create_nonce($action = 'spai_form_submit') {
        return wp_nonce_field($action, 'spai_form_nonce', true, false);
    }
    
    /**
     * Verify form nonce
     */
    public static function verify_nonce($nonce, $action = 'spai_form_submit') {
        return wp_verify_nonce($nonce, $action);
    }
    
    /**
     * Generate honeypot field
     */
    public static function honeypot_field() {
        // Use a field name that won't trigger autofill
        return '<div style="position: absolute; left: -5000px;" aria-hidden="true">
            <input type="text" name="spai_hp_firstname" tabindex="-1" autocomplete="new-password" value="">
        </div>';
    }
    
    /**
     * Check honeypot
     */
    public static function check_honeypot($value) {
        return empty($value);
    }
    
    /**
     * Sanitize form data
     */
    public static function sanitize_form_data($data) {
        $sanitized = array();
        
        foreach ($data as $key => $value) {
            if (is_array($value)) {
                $sanitized[$key] = self::sanitize_form_data($value);
            } else {
                $sanitized[$key] = sanitize_text_field($value);
            }
        }
        
        return $sanitized;
    }
    
    /**
     * Validate email
     */
    public static function validate_email($email) {
        return is_email($email);
    }
    
    /**
     * Rate limiting check
     */
    public static function check_rate_limit($identifier, $limit = 5, $window = 3600) {
        $transient_key = 'spai_rate_limit_' . md5($identifier);
        $attempts = get_transient($transient_key);
        
        if ($attempts === false) {
            set_transient($transient_key, 1, $window);
            return true;
        }
        
        if ($attempts >= $limit) {
            return false;
        }
        
        set_transient($transient_key, $attempts + 1, $window);
        return true;
    }
    
    /**
     * Generate secure token
     */
    public static function generate_token($length = 32) {
        return wp_generate_password($length, false);
    }
    
    /**
     * Encrypt sensitive data
     */
    public static function encrypt($data) {
        if (!function_exists('openssl_encrypt')) {
            return base64_encode($data);
        }
        
        $key = wp_salt('auth');
        $iv = substr(md5($key), 0, 16);
        
        return base64_encode(openssl_encrypt($data, 'AES-256-CBC', $key, 0, $iv));
    }
    
    /**
     * Decrypt sensitive data
     */
    public static function decrypt($data) {
        if (!function_exists('openssl_decrypt')) {
            return base64_decode($data);
        }
        
        $key = wp_salt('auth');
        $iv = substr(md5($key), 0, 16);
        
        return openssl_decrypt(base64_decode($data), 'AES-256-CBC', $key, 0, $iv);
    }
}
