<?php
/**
 * Phone number utility
 *
 * @package SPAI_Contact_Form
 */

class SPAI_Phone_Helper {
    
    /**
     * Format phone number
     */
    public static function format_phone($phone, $country_code = null) {
        // Remove all non-numeric characters except +
        $phone = preg_replace('/[^0-9+]/', '', $phone);
        
        // If no + at start, add country code
        if (strpos($phone, '+') !== 0 && $country_code) {
            $phone = '+' . $country_code . $phone;
        }
        
        return $phone;
    }
    
    /**
     * Validate phone number
     */
    public static function validate_phone($phone) {
        // Must start with + and have at least 7 digits
        return preg_match('/^\+[1-9]\d{6,14}$/', $phone);
    }
    
    /**
     * Get country calling codes
     */
    public static function get_country_codes() {
        return array(
            'US' => '1',
            'CA' => '1',
            'GB' => '44',
            'AU' => '61',
            'DE' => '49',
            'FR' => '33',
            'IT' => '39',
            'ES' => '34',
            'MX' => '52',
            'BR' => '55',
            'JP' => '81',
            'CN' => '86',
            'IN' => '91',
            'RU' => '7',
            'ZA' => '27'
            // Add more as needed
        );
    }
    
    /**
     * Extract country code from phone
     */
    public static function extract_country_code($phone) {
        $phone = preg_replace('/[^0-9+]/', '', $phone);
        
        if (strpos($phone, '+') !== 0) {
            return null;
        }
        
        // Common country codes by length
        $codes = array(
            1 => array('1', '7'),
            2 => array('20', '27', '30', '31', '32', '33', '34', '36', '39', '40', '41', '43', '44', '45', '46', '47', '48', '49', '51', '52', '53', '54', '55', '56', '57', '58', '60', '61', '62', '63', '64', '65', '66', '81', '82', '84', '86', '90', '91', '92', '93', '94', '95', '98'),
            3 => array('212', '213', '216', '218', '220', '221', '222', '223', '224', '225', '226', '227', '228', '229', '230', '231', '232', '233', '234', '235', '236', '237', '238', '239', '240', '241', '242', '243', '244', '245', '246', '248', '249', '250', '251', '252', '253', '254', '255', '256', '257', '258', '260', '261', '262', '263', '264', '265', '266', '267', '268', '269', '290', '291', '297', '298', '299', '350', '351', '352', '353', '354', '355', '356', '357', '358', '359', '370', '371', '372', '373', '374', '375', '376', '377', '378', '380', '381', '382', '383', '385', '386', '387', '389', '420', '421', '423', '500', '501', '502', '503', '504', '505', '506', '507', '508', '509', '590', '591', '592', '593', '594', '595', '596', '597', '598', '599', '670', '672', '673', '674', '675', '676', '677', '678', '679', '680', '681', '682', '683', '684', '685', '686', '687', '688', '689', '690', '691', '692', '850', '852', '853', '855', '856', '880', '886', '960', '961', '962', '963', '964', '965', '966', '967', '968', '970', '971', '972', '973', '974', '975', '976', '977', '992', '993', '994', '995', '996', '998')
        );
        
        $phone_without_plus = substr($phone, 1);
        
        // Check 3-digit codes first
        if (strlen($phone_without_plus) >= 3) {
            $potential_code = substr($phone_without_plus, 0, 3);
            if (in_array($potential_code, $codes[3])) {
                return $potential_code;
            }
        }
        
        // Check 2-digit codes
        if (strlen($phone_without_plus) >= 2) {
            $potential_code = substr($phone_without_plus, 0, 2);
            if (in_array($potential_code, $codes[2])) {
                return $potential_code;
            }
        }
        
        // Check 1-digit codes
        if (strlen($phone_without_plus) >= 1) {
            $potential_code = substr($phone_without_plus, 0, 1);
            if (in_array($potential_code, $codes[1])) {
                return $potential_code;
            }
        }
        
        return null;
    }
}
