<?php
/**
 * The core plugin class
 *
 * @package SPAI_Contact_Form
 */

class SPAI_Core {
    
    /**
     * The loader that's responsible for maintaining and registering all hooks
     */
    protected $loader;
    
    /**
     * The unique identifier of this plugin
     */
    protected $plugin_name;
    
    /**
     * The current version of the plugin
     */
    protected $version;
    
    /**
     * Define the core functionality of the plugin
     */
    public function __construct() {
        $this->version = SPAI_CONTACT_FORM_VERSION;
        $this->plugin_name = 'spai-contact-form';
        
        $this->load_dependencies();
        $this->set_locale();
        $this->define_admin_hooks();
        $this->define_public_hooks();
    }
    
    /**
     * Load the required dependencies for this plugin
     */
    private function load_dependencies() {
        /**
         * The class responsible for orchestrating the actions and filters
         */
        require_once SPAI_CONTACT_FORM_PLUGIN_DIR . 'includes/core/class-spai-loader.php';
        
        /**
         * The class responsible for defining internationalization functionality
         */
        require_once SPAI_CONTACT_FORM_PLUGIN_DIR . 'includes/core/class-spai-i18n.php';
        
        /**
         * The class responsible for defining all actions that occur in the admin area
         */
        require_once SPAI_CONTACT_FORM_PLUGIN_DIR . 'includes/admin/class-spai-admin.php';
        
        /**
         * The class responsible for defining all actions that occur in the public-facing side
         */
        require_once SPAI_CONTACT_FORM_PLUGIN_DIR . 'includes/frontend/class-spai-public.php';
        
        /**
         * Core functionality classes
         */
        require_once SPAI_CONTACT_FORM_PLUGIN_DIR . 'includes/core/class-spai-db-handler.php';
        require_once SPAI_CONTACT_FORM_PLUGIN_DIR . 'includes/core/class-spai-form-handler.php';
        require_once SPAI_CONTACT_FORM_PLUGIN_DIR . 'includes/core/class-spai-field-manager.php';
        
        /**
         * Utility classes
         */
        require_once SPAI_CONTACT_FORM_PLUGIN_DIR . 'includes/utils/class-spai-security.php';
        require_once SPAI_CONTACT_FORM_PLUGIN_DIR . 'includes/utils/class-spai-file-handler.php';
        require_once SPAI_CONTACT_FORM_PLUGIN_DIR . 'includes/utils/class-spai-phone-helper.php';
        
        /**
         * Integration base class
         */
        require_once SPAI_CONTACT_FORM_PLUGIN_DIR . 'includes/integrations/class-spai-integration-base.php';
        
        $this->loader = new SPAI_Loader();
    }
    
    /**
     * Define the locale for this plugin for internationalization
     */
    private function set_locale() {
        $plugin_i18n = new SPAI_i18n();
        $this->loader->add_action('plugins_loaded', $plugin_i18n, 'load_plugin_textdomain');
    }
    
    /**
     * Register all of the hooks related to the admin area functionality
     */
    private function define_admin_hooks() {
        $plugin_admin = new SPAI_Admin($this->get_plugin_name(), $this->get_version());
        
        $this->loader->add_action('admin_enqueue_scripts', $plugin_admin, 'enqueue_styles');
        $this->loader->add_action('admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts');
        
        // Add menu items
        $this->loader->add_action('admin_menu', $plugin_admin, 'add_plugin_admin_menu');
        
        // Add settings link on plugin page
        $this->loader->add_filter('plugin_action_links_' . SPAI_CONTACT_FORM_PLUGIN_BASENAME, $plugin_admin, 'add_action_links');
        
        // Ajax handlers for admin
        $this->loader->add_action('wp_ajax_spai_save_form', $plugin_admin, 'ajax_save_form');
        $this->loader->add_action('wp_ajax_spai_delete_form', $plugin_admin, 'ajax_delete_form');
        $this->loader->add_action('wp_ajax_spai_test_integration', $plugin_admin, 'ajax_test_integration');
        $this->loader->add_action('wp_ajax_spai_get_monday_boards', $plugin_admin, 'ajax_get_monday_boards');
        $this->loader->add_action('wp_ajax_spai_get_monday_columns', $plugin_admin, 'ajax_get_monday_columns');
        $this->loader->add_action('wp_ajax_spai_import_monday_fields', $plugin_admin, 'ajax_import_monday_fields');
        $this->loader->add_action('wp_ajax_spai_save_integrations', $plugin_admin, 'ajax_save_integrations');
        $this->loader->add_action('wp_ajax_spai_save_field_mapping', $plugin_admin, 'ajax_save_field_mapping');
        $this->loader->add_action('wp_ajax_spai_export_form', $plugin_admin, 'ajax_export_form');
        $this->loader->add_action('wp_ajax_spai_import_form', $plugin_admin, 'ajax_import_form');
        $this->loader->add_action('wp_ajax_spai_export_submissions', $plugin_admin, 'ajax_export_submissions');
        $this->loader->add_action('wp_ajax_spai_test_email', $plugin_admin, 'ajax_test_email');
        $this->loader->add_action('wp_ajax_spai_send_real_test_email', $plugin_admin, 'ajax_send_real_test_email');
    }
    
    /**
     * Register all of the hooks related to the public-facing functionality
     */
    private function define_public_hooks() {
        $plugin_public = new SPAI_Public($this->get_plugin_name(), $this->get_version());
        
        $this->loader->add_action('wp_enqueue_scripts', $plugin_public, 'enqueue_styles');
        $this->loader->add_action('wp_enqueue_scripts', $plugin_public, 'enqueue_scripts');
        
        // Register shortcode
        $this->loader->add_action('init', $plugin_public, 'register_shortcode');
        
        // Ajax handlers for form submission
        $this->loader->add_action('wp_ajax_spai_submit_form', $plugin_public, 'ajax_submit_form');
        $this->loader->add_action('wp_ajax_nopriv_spai_submit_form', $plugin_public, 'ajax_submit_form');

        // Chat widget - loads in footer when enabled
        $this->loader->add_action('wp_footer', $plugin_public, 'maybe_render_chat_widget');
    }
    
    /**
     * Run the loader to execute all of the hooks with WordPress
     */
    public function run() {
        $this->loader->run();
    }
    
    /**
     * The name of the plugin used to uniquely identify it
     */
    public function get_plugin_name() {
        return $this->plugin_name;
    }
    
    /**
     * The reference to the class that orchestrates the hooks
     */
    public function get_loader() {
        return $this->loader;
    }
    
    /**
     * Retrieve the version number of the plugin
     */
    public function get_version() {
        return $this->version;
    }
}
