
## Prefill examples

How to prefill the values (for CALL TO ACTION!!!!!)
https://chicagoroofdeck.com/contact-2/?spai_project_services=Shade%20Structure

## Campaings Setup

Google:
test 
{lpurl}?utm_source=google&utm_medium=cpc&utm_campaign={campaignid}&utm_content={adgroupid}&utm_term={keyword}&gclid={gclid}

  ✅ Google will replace:
  - {lpurl} → Your actual landing page URL
  - {campaignid} → Actual campaign id
  - {adgroupid} → Actual ad group ID number
  - {keyword} → Actual keyword that triggered the ad
  - {gclid} → Actual Google click identifie


Facebook:
utm_source=facebook&utm_medium={{placement}}&utm_campaign={{campaign.name}}&utm_content={{adset.name}}_{{ad.name}}&utm_term={{ad.name}}&fbclid={{ad.id}}


  ✅ Facebook will replace:
  - {{placement}} → feed, stories, audience_network, etc.
  - {{campaign.name}} → Actual campaign name
  - {{adset.name}} → Actual ad set name
  - {{ad.name}} → Actual ad name
  - {{ad.id}} → Actual Facebook ad ID

# SPAI Contact Form Plugin

A unified WordPress contact form system with modular integrations for Monday.com, SalesPartnerAI, and future CRMs.

## 📋 Features

- **Flexible Form Builder** - Create custom forms with drag-and-drop interface
- **Multiple Field Types** - Text, email, phone, select, multichoice, file upload, and more
- **GET Parameter Prefilling** - Prefill form fields via URL parameters
- **Monday.com Integration** - Automatic lead submission to Monday boards
- **SalesPartnerAI Integration** - Send leads to SalesPartnerAI system
- **File Upload Support** - Drag-and-drop file uploads with validation
- **reCAPTCHA Protection** - Built-in spam protection
- **Mobile Responsive** - Works on all devices

## 🚀 Quick Start

### 1. Installation
Plugin is automatically deployed to all 3 production sites:
- `synlawnchicago-com`
- `aluoutdoorsystems-com` 
- `chicagoroofdeck-com`

### 2. Basic Usage
Add forms to pages using shortcode:
```php
[spai_form id="1"]
```

## 🔗 GET Parameter Prefilling

### Basic Text Fields
```
?spai_first_name=John&spai_email=john@example.com&spai_phone=555-1234
```

### Select Fields
```
?spai_state=California&spai_role=Home Owner&spai_project_type=Residential
```

### Multichoice Fields (Multiple Values)
```
?spai_building-type=Condo,Single Family Home&spai_space-location=Roof of Building,Ground Level
```

### Complete Example URL
```
https://yoursite.com/contact/?spai_first_name=John&spai_last_name=Doe&spai_email=john@example.com&spai_phone=555-1234&spai_building-type=Condo,Office/ Commercial&spai_project_services=Decking,Lighting
```

## 📝 Available Field Types

### Standard Fields
- **Text**: `spai_first_name`, `spai_last_name`, `spai_street`, `spai_city`, `spai_zip`
- **Email**: `spai_email`
- **Phone**: `spai_phone` (international format supported)
- **Date**: `spai_estimated_start_date` (YYYY-MM-DD format)
- **Textarea**: `spai_message`

### Select Fields
- **State**: `spai_state` (e.g., `California`, `Illinois`)
- **Role**: `spai_role` (`Home Owner`, `Property Manager`, `Building Owner`, `Other`)
- **Project Type**: `spai_project_type` (`Residential`, `Commercial`, `Government`)

### Multichoice Fields (Comma-separated values)
- **Building Type**: `spai_building-type`
  - Options: `Single Family Home`, `Condo`, `Shared Multi-Residential`, `Hospitality/ Restaurant`, `Office/ Commercial`, `Other`
  
- **Space Location**: `spai_space-location`
  - Options: `Roof of Building`, `Roof of Garage`, `Ground Level`, `Rear of building Deck`, `Other`
  
- **Project Services**: `spai_project_services`
  - Options: `Decking`, `Shade Structure`, `Grill/ Kitchen Area`, `Seating area`, `Fire Pit`, `TV & Audio`, `Privacy Screening`, `Lighting`, `Heaters`, `Planters + Landscaping`, `Hot Tub`, `Synthetic Turf`, `Demolition`, `Roofing`, `Structural work`, `Masonry`, `Railings`, `Permitting Service`, `Architectural Service`, `Engineering Service`, `Other`

## 🔧 Configuration

### Admin Interface
Access admin panel at: `/wp-admin/admin.php?page=spai-contact-form`

### Integration Settings
- **Monday.com**: Configure API key and board mappings
- **SalesPartnerAI**: Set up backend API endpoint
- **reCAPTCHA**: Add site key and secret key

## 🧪 Testing

### Manual Testing
1. Visit form page with GET parameters
2. Verify fields are prefilled
3. Submit form to test integrations

### Automated Testing
```bash
# Run comprehensive form tests
cd /tmp && node test_comprehensive_prefill.js
```

### Debugging
Check error logs:
```bash
tail -f "/path/to/wordpress/logs/php/error.log" | grep SPAI
```

## 📁 File Structure

```
/spai-contact-form/
├── spai-contact-form.php           # Main plugin file
├── README.md                       # This file
├── uninstall.php                   # Cleanup on uninstall
├── /assets/
│   ├── /css/                      # Styles
│   ├── /js/                       # JavaScript
│   └── /vendor/                   # Third-party libraries
├── /includes/
│   ├── /core/                     # Core functionality
│   ├── /admin/                    # Admin interface
│   ├── /integrations/             # Monday, SalesPartner, etc.
│   ├── /frontend/                 # Shortcode & AJAX
│   └── /utils/                    # Helper functions
├── /templates/
│   ├── /admin/                    # Admin templates
│   └── /frontend/                 # Form templates
└── /docs/                         # Documentation
```

## 🔗 API Integrations

### Monday.com
- **Board ID**: 2744249780 (Leads)
- **Key Fields**: Name, email, phone, address details
- **Address Unit Field**: Maps to `dup__of_address` column

### SalesPartnerAI
- **Endpoint**: `http://localhost:3333/api/v1/forms/public/contact-form`
- **Format**: JSON with nested address and metadata objects

## 🛠️ Development

### Local Development
- **Site**: http://spai-test.local/
- **Test Form**: http://spai-test.local/?page_id=2
- **Admin**: http://spai-test.local/wp-admin/

### Database Tables
- `wp_spai_forms` - Form configurations
- `wp_spai_submissions` - Form submissions
- `wp_spai_integration_queue` - Integration processing queue

## 🚢 Deployment

### Production Deployment
```bash
# Deploy to all 3 production sites
rsync -avz --delete --exclude='.git' -e "ssh -p 8022" \
  "/Users/andre/Local Sites/spai-test/app/public/wp-content/plugins/spai-contact-form/" \
  "andre@149.28.121.251:/tmp/spai-contact-form-temp/"

ssh -p 8022 andre@149.28.121.251 << 'EOF'
sudo rsync -av --delete /tmp/spai-contact-form-temp/ /usr/local/lsws/synlawnchicago-com/html/wp-content/plugins/spai-contact-form/
sudo chown -R nobody:nogroup /usr/local/lsws/synlawnchicago-com/html/wp-content/plugins/spai-contact-form/
sudo rsync -av --delete /tmp/spai-contact-form-temp/ /usr/local/lsws/aluoutdoorsystems-com/html/wp-content/plugins/spai-contact-form/
sudo chown -R nobody:nogroup /usr/local/lsws/aluoutdoorsystems-com/html/wp-content/plugins/spai-contact-form/
sudo rsync -av --delete /tmp/spai-contact-form-temp/ /usr/local/lsws/chicagoroofdeck-com/html/wp-content/plugins/spai-contact-form/
sudo chown -R nobody:nogroup /usr/local/lsws/chicagoroofdeck-com/html/wp-content/plugins/spai-contact-form/
sudo rm -rf /tmp/spai-contact-form-temp/
EOF
```

## 🔒 Security Features

- **Nonce Verification** - CSRF protection
- **Input Sanitization** - All user input sanitized
- **File Upload Validation** - Type and size restrictions
- **Honeypot Fields** - Bot detection
- **reCAPTCHA Integration** - Spam protection

## 📊 Examples

### Marketing Campaign URLs
```html
<!-- Google Ads Landing -->
<a href="/contact/?spai_first_name=&spai_email=&spai_phone=&spai_project_services=Decking,Lighting">Get Quote</a>

<!-- Email Campaign -->
<a href="/contact/?spai_role=Home Owner&spai_project_type=Residential&spai_building-type=Single Family Home">Start Project</a>

<!-- Social Media -->
<a href="/contact/?spai_space-location=Roof of Building&spai_project_services=Shade Structure,Seating area">Roof Deck Quote</a>
```

### CRM Integration URLs
```html
<!-- From CRM with known customer data -->
<a href="/contact/?spai_first_name=John&spai_last_name=Smith&spai_email=john@example.com&spai_phone=555-0123&spai_city=Chicago&spai_state=Illinois">Update Project</a>
```

## ⚡ Performance

- **Optimized Loading** - Scripts only load when shortcode is used
- **Minimal Dependencies** - Only essential libraries included
- **Caching Friendly** - No dynamic content in cached areas

## 📞 Support

### Error Reporting
Check logs and report issues with:
- **URL used**
- **Expected vs actual behavior** 
- **Browser console errors**
- **Server error logs**

### Version History
- **v1.0.0** - Initial release with all field types and GET prefilling

---

**Last Updated**: August 2025  
**Plugin Version**: 1.0.0  
**WordPress Compatibility**: 5.8+  
**PHP Compatibility**: 7.4+